/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.Iterator;
import java.util.List;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class TileEntitySCTE
extends TileEntity
implements INameable {
    private boolean viewActivated = false;
    private boolean attacks = false;
    private boolean canBeNamed = false;
    private String customName = "name";
    private double attackRange = 0.0;
    private int blockPlaceCooldown = 30;
    private int viewCooldown = this.getViewCooldown();
    private int ticksBetweenAttacks = 0;
    private int attackCooldown = 0;
    private Class<?> typeToAttack = Entity.class;

    public void func_145845_h() {
        List list;
        AxisAlignedBB axisalignedbb;
        int k;
        int j;
        int i;
        if (this.viewActivated) {
            if (this.blockPlaceCooldown > 0) {
                --this.blockPlaceCooldown;
                return;
            }
            if (this.viewCooldown > 0) {
                --this.viewCooldown;
                return;
            }
            i = this.field_145851_c;
            j = this.field_145848_d;
            k = this.field_145849_e;
            axisalignedbb = AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)i, (double)j, (double)k).func_72314_b(5.0, 5.0, 5.0);
            list = this.field_145850_b.func_72872_a(EntityLivingBase.class, axisalignedbb);
            for (EntityLivingBase entity : list) {
                double eyeHeight = entity.func_70047_e();
                boolean isPlayer = entity instanceof EntityPlayer;
                Vec3 lookVec = Vec3.func_72443_a((double)(entity.field_70165_t + entity.func_70040_Z().field_72450_a * 5.0), (double)(eyeHeight + entity.field_70163_u + entity.func_70040_Z().field_72448_b * 5.0), (double)(entity.field_70161_v + entity.func_70040_Z().field_72449_c * 5.0));
                MovingObjectPosition mop = this.field_145850_b.func_72933_a(Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)entity.func_70047_e()), (double)entity.field_70161_v), lookVec);
                if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || mop.field_72311_b != this.field_145851_c || mop.field_72312_c != this.field_145848_d || mop.field_72309_d != this.field_145849_e || (!isPlayer || !this.activatedOnlyByPlayer()) && this.activatedOnlyByPlayer()) continue;
                this.entityViewed(entity);
                this.viewCooldown = this.getViewCooldown();
            }
        }
        if (this.attacks) {
            if (this.attackCooldown < this.getTicksBetweenAttacks()) {
                ++this.attackCooldown;
                return;
            }
            if (this.canAttack()) {
                i = this.field_145851_c;
                j = this.field_145848_d;
                k = this.field_145849_e;
                axisalignedbb = AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1)).func_72314_b(this.getAttackRange(), this.getAttackRange(), this.getAttackRange());
                list = this.field_145850_b.func_72872_a(this.entityTypeToAttack(), axisalignedbb);
                Iterator iterator = list.iterator();
                if (!this.field_145850_b.field_72995_K) {
                    boolean attacked = false;
                    while (iterator.hasNext()) {
                        Entity mobToAttack = (Entity)iterator.next();
                        if (mobToAttack == null || mobToAttack instanceof EntityItem || !this.shouldAttackEntityType(mobToAttack) || !this.attackEntity(mobToAttack)) continue;
                        attacked = true;
                    }
                    if (attacked || this.shouldRefreshAttackCooldown()) {
                        this.attackCooldown = 0;
                    }
                    if (attacked || this.shouldSyncToClient()) {
                        this.sync();
                    }
                }
            }
        }
    }

    public void entityViewed(EntityLivingBase entity) {
    }

    public boolean attackEntity(Entity entity) {
        return false;
    }

    public boolean canAttack() {
        return false;
    }

    private boolean shouldAttackEntityType(Entity entity) {
        if (entity.getClass() == EntityPlayer.class || entity.getClass() == EntityPlayerMP.class) {
            return entity.getClass() == EntityPlayer.class || entity.getClass() == EntityPlayerMP.class || entity.getClass() == EntityPlayerSP.class || entity.getClass() == EntityClientPlayerMP.class;
        }
        return entity.getClass() == this.typeToAttack;
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("viewActivated", this.viewActivated);
        par1NBTTagCompound.func_74757_a("attacks", this.attacks);
        par1NBTTagCompound.func_74757_a("canBeNamed", this.canBeNamed);
        par1NBTTagCompound.func_74768_a("viewCooldown", this.viewCooldown);
        par1NBTTagCompound.func_74780_a("attackRange", this.attackRange);
        par1NBTTagCompound.func_74768_a("attackCooldown", this.attackCooldown);
        par1NBTTagCompound.func_74768_a("ticksBetweenAttacks", this.ticksBetweenAttacks);
        par1NBTTagCompound.func_74778_a("customName", this.customName);
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("viewActivated")) {
            this.viewActivated = par1NBTTagCompound.func_74767_n("viewActivated");
        }
        if (par1NBTTagCompound.func_74764_b("attacks")) {
            this.attacks = par1NBTTagCompound.func_74767_n("attacks");
        }
        if (par1NBTTagCompound.func_74764_b("canBeNamed")) {
            this.canBeNamed = par1NBTTagCompound.func_74767_n("canBeNamed");
        }
        if (par1NBTTagCompound.func_74764_b("viewCooldown")) {
            this.viewCooldown = par1NBTTagCompound.func_74762_e("viewCooldown");
        }
        if (par1NBTTagCompound.func_74764_b("attackRange")) {
            this.attackRange = par1NBTTagCompound.func_74769_h("attackRange");
        }
        if (par1NBTTagCompound.func_74764_b("attackCooldown")) {
            this.attackCooldown = par1NBTTagCompound.func_74762_e("attackCooldown");
        }
        if (par1NBTTagCompound.func_74764_b("ticksBetweenAttacks")) {
            this.ticksBetweenAttacks = par1NBTTagCompound.func_74762_e("ticksBetweenAttacks");
        }
        if (par1NBTTagCompound.func_74764_b("customName")) {
            this.customName = par1NBTTagCompound.func_74779_i("customName");
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onTileEntityDestroyed();
    }

    public void onTileEntityDestroyed() {
    }

    public void sync() {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            ClientUtils.syncTileEntity(this);
        } else {
            MinecraftServer.func_71276_C().func_71203_ab().func_148540_a(this.func_145844_m());
        }
    }

    public TileEntitySCTE activatedByView() {
        this.viewActivated = true;
        return this;
    }

    public int getViewCooldown() {
        return 0;
    }

    public boolean activatedOnlyByPlayer() {
        return true;
    }

    public boolean isActivatedByView() {
        return this.viewActivated;
    }

    public TileEntitySCTE attacks(Class<?> type, double range, int cooldown) {
        this.attacks = true;
        this.typeToAttack = type;
        this.attackRange = range;
        this.ticksBetweenAttacks = cooldown;
        return this;
    }

    public Class<?> entityTypeToAttack() {
        return this.typeToAttack;
    }

    public double getAttackRange() {
        return this.attackRange;
    }

    public int getTicksBetweenAttacks() {
        return this.ticksBetweenAttacks;
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public void setAttackCooldown(int cooldown) {
        this.attackCooldown = cooldown;
    }

    public void attackNextTick() {
        this.attackCooldown = this.ticksBetweenAttacks;
    }

    public boolean shouldRefreshAttackCooldown() {
        return true;
    }

    public boolean shouldSyncToClient() {
        return true;
    }

    public boolean doesAttack() {
        return this.attacks;
    }

    public TileEntitySCTE nameable() {
        this.canBeNamed = true;
        return this;
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public void setCustomName(String customName) {
        this.customName = customName;
        this.sync();
    }

    @Override
    public boolean hasCustomName() {
        return this.customName != null && !this.customName.matches("name");
    }

    @Override
    public boolean canBeNamed() {
        return this.canBeNamed;
    }
}

